package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.dao.CmsmwDao;
import com.topsunit.scanservice.ximai.dao.SfctaDao;
import com.topsunit.scanservice.ximai.dao.SfctcDao;
import com.topsunit.scanservice.ximai.dto.SfctaCriteria;
import com.topsunit.scanservice.ximai.dto.SfctaDto;
import com.topsunit.scanservice.ximai.dto.mapper.SfctaMapper;
import com.topsunit.scanservice.ximai.entity.Sfcta;
import com.topsunit.scanservice.ximai.entity.Sfctc;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>Title: SfctaService</p>
 * <p>Description: 工单工艺信息档 service</p>
 *
 * @author xi.feng
 * @version V1.0
 */
@Service
public class SfctaService {
    private final SfctaDao sfctaDao;
    private final SfctcDao sfctcDao;
    private final CmsmwDao cmsmwDao;
    private final SfctaMapper sfctaMapper;

    public SfctaService(SfctaDao sfctaDao, SfctcDao sfctcDao, CmsmwDao cmsmwDao, SfctaMapper sfctaMapper) {
        this.sfctaDao = sfctaDao;
        this.sfctcDao = sfctcDao;
        this.cmsmwDao = cmsmwDao;
        this.sfctaMapper = sfctaMapper;
    }

    public Optional<SfctaDto> getForScan(SfctaCriteria criteria){
        return sfctaDao.findFirstByTa001AndTa002AndTa003(criteria.getTa001(), criteria.getTa002(), criteria.getTa003())
                .map(i ->{
                    SfctaDto sfctaDto = sfctaMapper.toSfctaDto(i);
                    sfctaDto.setInProcess(getInProcessQuantity(i));
                    return sfctaDto;
                })
                .map(i ->{
                    cmsmwDao.findById(i.getTa004())
                            .ifPresent(j->i.setMw002(j.getMw002()));
                    return i;
                });
    }

    private BigDecimal getInProcessQuantity(Sfcta sfcta) {
        BigDecimal sfctcTc036Count = BigDecimal.ZERO;
        List<Sfctc> sfctcs = sfctcDao.findAllByTc004AndTc005AndTc006AndTc022(sfcta.getTa001(), sfcta.getTa002(), sfcta.getTa003(), "N")
                .stream()
                .filter(i -> {
                    String tc013 = i.getTc013().trim();
                    if (tc013.equals("1") || tc013.equals("2") || tc013.equals("4")) {
                        return true;
                    }
                    return false;
                })
                .collect(Collectors.toList());
        for (Sfctc sfctc : sfctcs) {
            sfctcTc036Count = sfctcTc036Count.add(sfctc.getTc036());
        }
        return sfcta.getTa010()
                .add(sfcta.getTa013())
                .add(sfcta.getTa016())
                .subtract(sfcta.getTa011())
                .subtract(sfcta.getTa012())
                .subtract(sfcta.getTa056())
                .subtract(sfcta.getTa014())
                .subtract(sfcta.getTa015())
                .subtract(sfctcTc036Count);
    }
}
