package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.entity.*;
import com.topsunit.scanservice.ximai.utils.MessageUtils;
import com.topsunit.scanservice.ximai.webapi.MesStorageDetailRecordService;
import com.topsunit.scanservice.ximai.webapi.dto.StorageDetailRecordCreate;
import com.topsunit.scanservice.ximai.webapi.dto.StorageDetailRecordResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 完工入库申请服务
 */
@Service
public class MoctfService {

    private static final Logger log = LoggerFactory.getLogger(MoctfService.class);

    @Autowired
    private MoctfDao moctfDao;
    @Autowired
    private MoctgDao moctgDao;
    @Autowired
    private InvmbDao invmbDao;
    @Autowired
    private InvmcDao invmcDao;
    @Autowired
    private MoctaDao moctaDao;
    @Autowired
    private MesStorageDetailRecordService mesStorageDetailRecordService;
    @Transactional
    public void create(MoctfCreateParams create){
        Moctf moctf = BeanUtil.toBeanIgnoreError(create, Moctf.class);
        Calendar curr = Calendar.getInstance();
        String currStr = DateUtil.format(curr.getTime(), "yyyyMMdd");
        if(StringUtils.isEmpty(create.getTf002())){
            moctf.setTf002(this.getNewTf002(create.getTf001()));
        }
        moctf.setTf003(currStr);
        moctf.setTf012(currStr);
        AtomicReference<String> ta083 = new AtomicReference<String>();
        create.getDetails().forEach(s->{
            Moctg moctg = BeanUtil.toBeanIgnoreError(s, Moctg.class);
            //查询工单
            Mocta mocta = moctaDao.findById(new MoctaId(s.getTg014(), s.getTg015())).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应工单：{0},{1}",s.getTg014(),s.getTg015())));
            //查询物料
            Invmb invmb = invmbDao.findById(mocta.getTa006()).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应物料：{0}", s.getTg004())));
            if(StringUtils.isEmpty(moctg.getTg002())){
                moctg.setTg002(moctf.getTf002());
            }
            moctg.setTg004(invmb.getMb001());
            moctg.setTg005(invmb.getMb002());
            moctg.setTg006(invmb.getMb003());
            moctg.setTg007(invmb.getMb004());
            moctg.setTg037(invmb.getMb004());
            moctg.setTg010(invmb.getMb017());
            ta083.set(mocta.getTa083());
            //查询物料默认仓库
            Invmc invmc = invmcDao.findById(new InvmcId(invmb.getMb001(), invmb.getMb017())).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应物料默认库：{0},{1}", invmb.getMb001(), invmb.getMb017())));
            moctg.setTg036(invmc.getMc015());
            moctg.setTg030(currStr);
            moctg.setTg038(moctg.getTg011());
            moctgDao.save(moctg);
        });
        moctf.setTf033(ta083.get());
        moctf.setTf023(create.getDetails().get(0).getTg011());
        moctf.setTf024(create.getDetails().get(0).getTg011());
        moctfDao.save(moctf);

        // 保存入库标签明细记录到 MES 系统
        if (create.getStorageDetails() != null && !create.getStorageDetails().isEmpty()) {
            create.getStorageDetails().forEach(detail -> {
                try {
                    StorageDetailRecordCreate storageDetailRecord = new StorageDetailRecordCreate();
                    storageDetailRecord.setWorkOrderType(detail.getWorkOrderType());
                    storageDetailRecord.setWorkOrderNo(detail.getWorkOrderNo());
                    storageDetailRecord.setBoxCode(detail.getBoxCode());
                    storageDetailRecord.setLabelNo(detail.getLabelNo());
                    
                    StorageDetailRecordResult result = mesStorageDetailRecordService.create(storageDetailRecord);
                    if(result.getCode()==200) {
                        log.info("保存入库明细记录成功：工单单别={}, 工单单号={}, 箱码={}, 小标签号={}",
                                detail.getWorkOrderType(), detail.getWorkOrderNo(), detail.getBoxCode(), detail.getLabelNo());
                    }else{
                        throw new TopsunitException(result.getMsg());
                    }
                } catch (Exception e) {
                    log.error("保存入库明细记录失败：工单单别={}, 工单单号={}, 箱码={}, 小标签号={}, 错误信息={}", 
                        detail.getWorkOrderType(), detail.getWorkOrderNo(), detail.getBoxCode(), detail.getLabelNo(), e.getMessage(), e);
                    // 不抛出异常，仅记录日志，避免影响主流程
                }
            });
        }
    }


    @Transactional
    public void create2(MoctfCreateParams2 create){
        Moctf moctf = BeanUtil.toBeanIgnoreError(new MoctfCreateParams(), Moctf.class);
        Calendar curr = Calendar.getInstance();
        String currStr = DateUtil.format(curr.getTime(), "yyyyMMdd");
        moctf.setTf001(create.getTg001());
        moctf.setTf002(this.getNewTf002(create.getTg001()));
        moctf.setTf003(currStr);
        moctf.setTf012(currStr);
        AtomicReference<String> ta083 = new AtomicReference<String>();

        Moctg moctg = BeanUtil.toBeanIgnoreError(new MoctgCreateParams(), Moctg.class);
        BeanUtil.copyProperties(create, moctg);
        //查询工单
        Mocta mocta = moctaDao.findById(new MoctaId(create.getTg014(), create.getTg015())).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应工单：{0},{1}",create.getTg014(),create.getTg015())));
        //查询物料
        Invmb invmb = invmbDao.findById(mocta.getTa006()).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应物料：{0}", mocta.getTa006())));
        moctg.setTg001(moctf.getTf001());
        moctg.setTg002(moctf.getTf002());
        moctg.setTg004(invmb.getMb001());
        moctg.setTg005(invmb.getMb002());
        moctg.setTg006(invmb.getMb003());
        moctg.setTg007(invmb.getMb004());
        moctg.setTg013(create.getTg011());
        moctg.setTg037(invmb.getMb004());
        moctg.setTg010(invmb.getMb017());
        ta083.set(mocta.getTa083());
        //查询物料默认仓库
        Invmc invmc = invmcDao.findById(new InvmcId(invmb.getMb001(), invmb.getMb017())).orElseThrow(()->new TopsunitException(MessageUtils.getMessage("未找到对应物料默认库：{0},{1}", invmb.getMb001(), invmb.getMb017())));
        moctg.setTg036(invmc.getMc015());
        moctg.setTg030(currStr);
        moctg.setTg038(moctg.getTg011());
        moctgDao.save(moctg);

        moctf.setTf033(ta083.get());
        moctf.setTf023(create.getTg011());
        moctf.setTf024(create.getTg011());
        moctfDao.save(moctf);

        // 保存入库标签明细记录到 MES 系统
        if (create.getStorageDetails() != null && !create.getStorageDetails().isEmpty()) {
            create.getStorageDetails().forEach(detail -> {
                try {
                    StorageDetailRecordCreate storageDetailRecord = new StorageDetailRecordCreate();
                    storageDetailRecord.setWorkOrderType(detail.getWorkOrderType());
                    storageDetailRecord.setWorkOrderNo(detail.getWorkOrderNo());
                    storageDetailRecord.setBoxCode(detail.getBoxCode());
                    storageDetailRecord.setLabelNo(detail.getLabelNo());
                    
                    StorageDetailRecordResult result = mesStorageDetailRecordService.create(storageDetailRecord);
                    log.info("保存入库明细记录成功：工单单别={}, 工单单号={}, 箱码={}, 小标签号={}", 
                        detail.getWorkOrderType(), detail.getWorkOrderNo(), detail.getBoxCode(), detail.getLabelNo());
                } catch (Exception e) {
                    log.error("保存入库明细记录失败：工单单别={}, 工单单号={}, 箱码={}, 小标签号={}, 错误信息={}", 
                        detail.getWorkOrderType(), detail.getWorkOrderNo(), detail.getBoxCode(), detail.getLabelNo(), e.getMessage(), e);
                    // 不抛出异常，仅记录日志，避免影响主流程
                }
            });
        }
    }


    private String getNewTf002(String tf001) {
        String prefix = com.topsunit.scanservice.ximai.common.DateUtil.currentDateString();
        return moctfDao.findFirstByTf001AndTf002StartingWithOrderByTf002Desc(tf001, prefix)
                .map(i -> {
                    int currentOrdianl = Integer.parseInt(i.getTf002().replace(prefix, ""));
                    return prefix + String.format("%03d", currentOrdianl + 1);
                })
                .orElse(prefix + "001");
    }
}
