package com.topsunit.scanservice.ximai.security.impl;

import com.topsunit.scanservice.ximai.common.StringUtil;
import com.topsunit.scanservice.ximai.security.Encryptor;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * <p>Title: EncryptorImpl</p>
 * <p>Description: EncryptorImpl</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/4
 */
@Component
public class EncryptorImpl implements Encryptor {
    private MessageDigest messageDigest;
    public EncryptorImpl() throws NoSuchAlgorithmException {
        messageDigest = MessageDigest.getInstance("SHA-256");
    }

    @Override
    public String hash(String s) {
        byte[] digest = messageDigest.digest(s.getBytes(StandardCharsets.UTF_8));
        return StringUtil.byteArrayTo16(digest);
    }
}
