package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * <p>Title: EX_ACCOUNT_INFO</p>
 * <p>Description: 套账表</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2025/1/9
 */
@Data
@Entity
@Table(name = "EX_ACCOUNT_INFO")
public class ExAccountInfo {
    @Id
    Integer id;

    @ApiModelProperty("套账名称")
    @Column(name = "ACCOUNT_NAME")
    String accountName;

    @ApiModelProperty("套账编码")
    @Column(name = "ACCOUNT_CODE")
    String accountCode;

    @ApiModelProperty("接口地睛")
    @Column(name = "API_URL")
    String apiUrl;

    @ApiModelProperty("条码系统地址")
    @Column(name = "BARCODE_URL")
    String barcodeUrl;

    @ApiModelProperty("MES接口地址")
    @Column(name = "MES_URL")
    String mesUrl;

    @ApiModelProperty("开启")
    @Column(name = "ENABLE")
    String enable;

    @ApiModelProperty("序号")
    @Column(name = "SERIAL")
    String serial;
}
