package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>Title: MoctfCreateParams</p>
 * <p>Description: 完工入库申请表头</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Data
public class MoctfCreateParams {

    @ApiModelProperty("入库单别")
    private String tf001="5801";
    /**
     * S+yyMMddxxxx
     */
    @ApiModelProperty("入库单号")
    private String tf002;

    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private String tf003;

    @ApiModelProperty("工厂编号")
    private String tf004="01";

    @ApiModelProperty("备注")
    private String tf005;

    @ApiModelProperty("审核码")
    private String tf006="N";

    @ApiModelProperty("生产记录更新码")
    private String tf007="N";

    @ApiModelProperty("生成分录-成本")
    private String tf010="N";

    @ApiModelProperty("签核状态码")
    private String tf014="N";

    @ApiModelProperty("自动扣料更新码")
    private String tf009="N";

    @ApiModelProperty("工作中心")
    private String tf011="0001";
    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    private String tf012;

    @ApiModelProperty("部门")
    private String tf016="04";

    @ApiModelProperty("项目编号")
    private String tf033;

    @ApiModelProperty("明细")
    private List<MoctgCreateParams> details;

    @ApiModelProperty("标签明细")
    private List<StorageDetailParams> storageDetails;

}
