package com.topsunit.scanservice.ximai.dao;

import com.topsunit.scanservice.ximai.dto.kanban.*;
import com.topsunit.scanservice.ximai.entity.Mocta;
import com.topsunit.scanservice.ximai.entity.MoctaId;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;

/**
 * Author:   Jack
 * Date:     2021/10/29 8:22
 * Description: 工单单头Dao
 */
public interface MoctaDao extends JpaRepository<Mocta, MoctaId>, JpaSpecificationExecutor<Mocta> {
    Optional<Mocta> findFirstByTa001AndTa002(String ta001, String ta002);

    /**
     * 物料配送完成率
     * @return
     */
    @Query(value = "select sum(b.TB004) denominator,sum(b.TB005) numerator from MOCTA a left join MOCTB b on a.TA001 = b.TB001 and a.TA002 = b.TB002 " +
            "where a.TA009 >= :start and a.TA009 < :end", nativeQuery = true)
    Optional<StockInCompleteRatio> statStockInCompleteRatio(@Param(value = "start") String start, @Param(value = "end")String end);

    /**
     * 采购到货完成率
     * @return
     */
    @Query(value = "select sum(TD008) denominator,sum(TD015) numerator from PURTD \n" +
            "where TD012 >= :start and TD012 < :end", nativeQuery = true)
    Optional<MaterialDistRatio> statMaterialDistRatio(@Param(value = "start") String start, @Param(value = "end")String end);

    /**
     * 销售发货及时率
     * @return
     */
    @Query(value = "select t1.TO001 applyType,t1.TO002 applyNo,t1.UDF01 planOutDate,t1.TO017 outQuantity,t1.TO024 planOutQuantity,t2.TG003 outDate from COPTO t1 \n" +
            "\tleft join (select max(TG003) TG003,TH045,TH046,TH047 from COPTG o1 left join COPTH o2 on o1.TG001 = o2.TH001\n" +
            "and o1.TG002 = o2.TH002 group by TH045,TH046,TH047) t2 on t1.TO001 = t2.TH045 and t1.TO002 = t2.TH046 and t1.TO003 = t2.TH047" +
            "\twhere t1.UDF01 >= :start and t1.UDF01 < :end", nativeQuery = true)
    List<SalesTimelyDeliveryRatio> statSalesTimelyDeliveryRatio(@Param(value = "start") String start, @Param(value = "end")String end);

    /**
     * 入库存趋势图
     * @return
     */
    @Query(value = "select f.TF003 startDate,sum(g.TG011) quantity from MOCTF f left join MOCTG g on f.TF001 = g.TG001 and f.TF002 = g.TG002\n" +
            "where f.TF003 >= :start and f.TF003 < :end group by f.TF003", nativeQuery = true)
    List<StockInTrend> statStockInTrend(@Param(value = "start") String start, @Param(value = "end")String end);
    /**
     * 出库存趋势图
     * @return
     */
    @Query(value = "select g.TG003 startDate,sum(h.TH008) quantity from COPTG g left join COPTH h on g.TG001 = h.TH001 and g.TG002 = h.TH002\n" +
            "where g.TG003 >= :start and g.TG003 < :end and g.TG023 ='Y' group by g.TG003", nativeQuery = true)
    List<StockOutTrend> statStockOutTrend(@Param(value = "start") String start, @Param(value = "end")String end);

    /**
     * 当月销售出库计划
     * @return
     */
    @Query(value = "select t1.TO007 itemCode,t1.TO001 applyType,t1.TO002 applyNo,t1.UDF01 planOutDate,t1.TO024 planOutNum,t1.TO017 outNum from COPTO t1 \n" +
            "where t1.UDF01 >= :start and t1.UDF01 < :end", nativeQuery = true)
    List<SalesOutboundPlan> salesOutboundPlanList(@Param(value = "start") String start, @Param(value = "end")String end);



}
