package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Purtb</p>
 * <p>Description: 请购单单身信息档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Data
@Entity
@IdClass(PurtbId.class)
public class Purtb extends EntityBase {
    @Id
    @ApiModelProperty("单别")
    private String tb001;
    @Id
    @ApiModelProperty("单号")
    private String tb002;
    @Id
    @ApiModelProperty("序号")
    private String tb003;
    @ApiModelProperty("品号")
    private String tb004;
    @ApiModelProperty("品名")
    private String tb005;
    @ApiModelProperty("规格")
    private String tb006;
    @ApiModelProperty("请购单位")
    private String tb007;
    @ApiModelProperty("仓库")
    private String tb008;
    @ApiModelProperty("请购数量")
    private BigDecimal tb009;
    @ApiModelProperty("需求日期")
    private String tb011;
    @ApiModelProperty("锁定码")
    private String tb020;
    @ApiModelProperty("采购码")
    private String tb021;
    @ApiModelProperty("备注")
    private String tb024;
    @ApiModelProperty("采购币种")
    private String tb016;
    @ApiModelProperty("审核码")
    private String tb025;
    /**
     * 销售单别
     */
    @ApiModelProperty("销售单别")
    private String tb029;
    /**
     * 销售单号
     */
    @ApiModelProperty("销售单号")
    private String tb030;
    /**
     * 销售序号
     */
    @ApiModelProperty("销售序号")
    private String tb031;
    /**
     * 急料
     */
    @ApiModelProperty("急料")
    private String tb032;
    @ApiModelProperty("结束")
    private String tb039;
    @ApiModelProperty("采购单位")
    private String tb015;
    @ApiModelProperty("采购单价")
    private BigDecimal tb017;
    @ApiModelProperty("采购金额")
    private BigDecimal tb018;
    @ApiModelProperty("税种")
    private String tb026;
    @ApiModelProperty("计价单位")
    private String tb043;
    @ApiModelProperty("计价数量")
    private String tb044;
    /**
     * 客户订单号
     */
    @ApiModelProperty("客户订单号")
    private String udf01;
    /**
     * 工单品号
     */
    @ApiModelProperty("工单品号")
    private String udf04;
    /**
     * 委外产品图号
     */
    @ApiModelProperty("委外产品图号")
    private String udf10;
    @ApiModelProperty("委外加工数量")
    private String udf11;
    @ApiModelProperty("委外工艺")
    private String udf12;

}
