package com.topsunit.scanservice.ximai.webapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.topsunit.scanservice.ximai.common.AppConfig;
import com.topsunit.scanservice.ximai.webapi.dto.PrintParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

/**
 * Author:   Jack
 * Date:     2021/11/03 16:53
 * Description:
 */
@Component
public class PrintApi {
    private static final Logger log = LoggerFactory.getLogger(PrintApi.class);
    private RestTemplate restTemplate;

    private final AppConfig appConfig;

    public PrintApi(AppConfig appConfig) {
        this.appConfig = appConfig;
        if (restTemplate == null) {
            restTemplate = restTemplate();
        }
    }

    //自创建RestTemplate
    private RestTemplate restTemplate() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(30000);// 设置连接超时，单位毫秒
        requestFactory.setReadTimeout(30000);  //设置读取超时
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(requestFactory);
        log.info("RestTemplate初始化完成");
        return restTemplate;
    }

    public void print(String templateKey, Integer printNumber, List<Map<String, Object>> codeList) throws JsonProcessingException {
        String url = appConfig.getPrintApiUrl();

        HttpHeaders requestHeader = new HttpHeaders();
        requestHeader.add("Content-Type", "application/json;charset=UTF-8");

        PrintParam param = new PrintParam();
        param.setTemplateKey(templateKey);
        param.setPrintNumber(printNumber);
        param.setCodeList(codeList);

        ObjectMapper objectMapper = new ObjectMapper();
        String jsonParam = objectMapper.writeValueAsString(param);
        HttpEntity<String> httpEntitys = new HttpEntity<>(jsonParam, requestHeader);

        ResponseEntity<String> exchange = restTemplate.postForEntity(url, httpEntitys, String.class);

        String resultRemote = exchange.getBody();//得到返回的值
    }
}
