package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.dto.mapper.SfctbMapper;
import com.topsunit.scanservice.ximai.entity.*;
import com.topsunit.scanservice.ximai.security.CurrentActor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>Title: SfctbService</p>
 * <p>Description: 转移单服务</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/28
 */
@Service
public class SfctbService {
    private final CmsmaDao cmsmaDao;
    private final CmsmcDao cmsmcDao;
    private final CmsniDao cmsniDao;
    private final CmsmgDao cmsmgDao;
    private final InvmbDao invmbDao;
    private final MoctaDao moctaDao;
    private final SfctaDao sfctaDao;
    private final SfctbDao sfctbDao;
    private final SfctcDao sfctcDao;
    private final CurrentActor currentActor;
    private final SfctbMapper sfctbMapper;

    public SfctbService(CmsmaDao cmsmaDao, CmsmcDao cmsmcDao, CmsniDao cmsniDao, CmsmgDao cmsmgDao, InvmbDao invmbDao, MoctaDao moctaDao, SfctaDao sfctaDao, SfctbDao sfctbDao, SfctcDao sfctcDao, CurrentActor currentActor, SfctbMapper sfctbMapper) {
        this.cmsmaDao = cmsmaDao;
        this.cmsmcDao = cmsmcDao;
        this.cmsniDao = cmsniDao;
        this.cmsmgDao = cmsmgDao;
        this.invmbDao = invmbDao;
        this.moctaDao = moctaDao;
        this.sfctaDao = sfctaDao;
        this.sfctbDao = sfctbDao;
        this.sfctcDao = sfctcDao;
        this.currentActor = currentActor;
        this.sfctbMapper = sfctbMapper;
    }

    /**
     * 录入转移单
     * @param params 录入转移单参数
     */
    @Transactional
    public void createForTransfer(SfctbCreateParams params) {
        String currentDate = DateUtil.currentDateString();
        Mocta mocta = moctaDao.findById(new MoctaId(params.getTc004(), params.getTc005()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到工单"));
        Invmb invmb = invmbDao.findById(mocta.getTa006())
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到品号"));
        Sfcta outSfcta = sfctaDao.findById(new SfctaId(params.getTc004(), params.getTc005(), params.getTc006(), params.getTb005()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到移出工艺"));
        Sfcta inSfcta = sfctaDao.findById(new SfctaId(params.getTc004(), params.getTc005(), params.getTc008(), params.getTb008()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到移入工艺"));
        Cmsma cmsma = cmsmaDao.findAll().stream()
                .findFirst()
                .orElseThrow(() -> new TopsunitException("未设置共享参数设置挡"));
        Optional<Cmsmg> cmsmg = cmsmgDao.findFirstByMg001OrderByMg002Desc("RMB");
        BigDecimal inProcessQuantity = getInProcessQuantity(outSfcta);
        if (params.getTc036().compareTo(inProcessQuantity) > 0) {
            throw new TopsunitException("转移数量不能超过在制量");
        }
        String tc039 = outSfcta.getTa033().trim().equals("0") ? "0" : "1";

        Sfctb sfctb = new Sfctb();
        sfctb.setTb001(params.getTb001()); // 转移单别
        sfctb.setTb002(getNewTG002()); // 转移单号
        sfctb.setTb003(currentDate);   // 转移日期
        sfctb.setTb004(outSfcta.getTa005().trim());  // 移出类别
        sfctb.setTb005(outSfcta.getTa006());  // 移出地
        sfctb.setTb006(outSfcta.getTa007());  // 移出地名称
        sfctb.setTb007(inSfcta.getTa005().trim()); // 移入类别
        sfctb.setTb008(inSfcta.getTa006()); // 移入地
        sfctb.setTb009(inSfcta.getTa007()); // 移入地名称
        sfctb.setTb010("01"); // 工厂编号
        sfctb.setTb011(0); // 打印次数
        sfctb.setTb012("N"); // 更新码
        sfctb.setTb013("N"); // 审核码
        // tb014
        sfctb.setTb015(currentDate); // 单据日期
        // tb016
        sfctb.setTb017("N"); // 签核状态码
        sfctb.setTb018(0); // 传送次数
        sfctb.setTb019("2"); // 税种
        sfctb.setTb020(cmsma.getMa004()); // 税率
        sfctb.setTb021("RMB"); // 币种
        sfctb.setTb022(cmsmg.map(Cmsmg::getMg003).orElse(BigDecimal.ONE)); // 汇率
        sfctb.setTb023(outSfcta.getTa051()); // 移出部门
        sfctb.setTb024(inSfcta.getTa051()); // 移入部门
        // tb025
        // tb026
        // tb027
        // tb029
        // tb030
        sfctb.setTb031(mocta.getTa083()); // 项目编号

        Sfctc sfctc = new Sfctc();
        sfctc.setTc001(sfctb.getTb001()); // 转移单单别
        sfctc.setTc002(sfctb.getTb002()); // 转移单单号
        sfctc.setTc003("0001"); // 序号
        sfctc.setTc004(mocta.getTa001()); // 工单单别
        sfctc.setTc005(mocta.getTa002()); // 工单单号
        sfctc.setTc006(outSfcta.getTa003()); // 移出加工顺序
        sfctc.setTc007(outSfcta.getTa004()); // 移出工艺
        sfctc.setTc008(inSfcta.getTa003()); // 移入加工顺序
        sfctc.setTc009(inSfcta.getTa004()); // 移入工艺
        sfctc.setTc010(invmb.getMb004()); // 单位
        // tc011
        sfctc.setTc012(outSfcta.getTa020()); // 计价单位
        sfctc.setTc013(params.getTc013()); // 类型
        sfctc.setTc014(tc039.equals("0") ? params.getTc036() : BigDecimal.ZERO);
        sfctc.setTc015(sfctc.getTc014());
        // tc016
        sfctc.setTc017(outSfcta.getTa021()); // 委外单价
        sfctc.setTc018(sfctb.getTb004().trim().equals("2")? sfctc.getTc015().multiply(sfctc.getTc017()) : BigDecimal.ZERO); // 加工金额
        // tc019
        sfctc.setTc020(params.getTc020()); // 使用人时
        sfctc.setTc021(params.getTc021()); // 使用机时
        sfctc.setTc022("N"); // 审核码
        sfctc.setTc023(outSfcta.getTa006()); // 移出地
        sfctc.setTc024(currentDate); // 预交货日期
        // tc025
        sfctc.setTc026("N"); // 结束
        sfctc.setTc027("N"); // 超期码
        // tc028
        // tc029
        // tc030
        // tc031
        sfctc.setTc032("********************"); // 批号
        // tc033
        // tc034
        sfctc.setTc035("N"); // 急料
        sfctc.setTc036(params.getTc036()); // 转移数量
        // tc037
        sfctc.setTc038(currentDate); // 验收日期
        sfctc.setTc039(tc039); // 检验状态
        // tc040
        sfctc.setTc041(inSfcta.getTa006()); // 移入地
        // tc042
        // tc043
        // tc044
        // tc045
        // tc046
        sfctc.setTc047(mocta.getTa006()); // 产品品号
        sfctc.setTc048(mocta.getTa034()); // 产品品名
        sfctc.setTc049(mocta.getTa035()); // 产品规格
        // tc051
        // tc052
        // tc053
        sfctc.setTc054("N"); // 报废码
        // tc055
        sfctc.setTc056("##########");
        // tc057
        sfctc.setTc058(currentDate); // 生产日期
        // tc059
        // tc060
        // tc061
        // tc062
        // tc063
        sfctc.setTcd01(currentActor.getActor().getMv001()); // 员工编号
        // tcd02
        sfctc.setTc064(mocta.getTa083()); // 项目编号

        sfctbDao.save(sfctb);
        sfctcDao.save(sfctc);
    }

    /**
     * 录入入库单
     * @param params 录入入库单参数
     */
    @Transactional
    public void createForStorage(SfctbCreateParams params){
        String currentDate = DateUtil.currentDateString();
        Mocta mocta = moctaDao.findById(new MoctaId(params.getTc004(), params.getTc005()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到工单"));
        Invmb invmb = invmbDao.findById(mocta.getTa006())
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到品号"));
        Sfcta outSfcta = sfctaDao.findById(new SfctaId(params.getTc004(), params.getTc005(), params.getTc006(), params.getTb005()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("未找到移出工艺"));
        Cmsmc cmsmc = cmsmcDao.findById(params.getTb008())
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("仓库不存在"));
        cmsniDao.findById(new CmsniId(params.getTb008(), params.getTc056()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .orElseThrow(() -> new TopsunitException("库位不存在"));
        Cmsma cmsma = cmsmaDao.findAll().stream()
                .findFirst().orElseThrow(() -> new TopsunitException("未设置共享参数设置挡"));
        Optional<Cmsmg> cmsmg = cmsmgDao.findFirstByMg001OrderByMg002Desc("RMB");
        BigDecimal inProcessQuantity = getInProcessQuantity(outSfcta);
        if (params.getTc036().compareTo(inProcessQuantity) > 0) {
            throw new TopsunitException("转移数量不能超过在制量");
        }
        String tc039 = outSfcta.getTa033().trim().equals("0") ? "0" : "1";

        Sfctb sfctb = new Sfctb();
        sfctb.setTb001(params.getTb001()); // 转移单别
        sfctb.setTb002(getNewTG002()); // 转移单号
        sfctb.setTb003(currentDate);   // 转移日期
        sfctb.setTb004(outSfcta.getTa005().trim());  // 移出类别
        sfctb.setTb005(outSfcta.getTa006());  // 移出地
        sfctb.setTb006(outSfcta.getTa007());  // 移出地名称
        sfctb.setTb007("3"); // 移入类别
        sfctb.setTb008(cmsmc.getMc001()); // 移入地
        sfctb.setTb009(cmsmc.getMc002()); // 移入地名称
        sfctb.setTb010("01"); // 工厂编号
        sfctb.setTb011(0); // 打印次数
        sfctb.setTb012("N"); // 更新码
        sfctb.setTb013("N"); // 审核码
        // tb014
        sfctb.setTb015(currentDate); // 单据日期
        // tb016
        sfctb.setTb017("N"); // 签核状态码
        sfctb.setTb018(0); // 传送次数
        sfctb.setTb019("2"); // 税种
        sfctb.setTb020(cmsma.getMa004()); // 税率
        sfctb.setTb021("RMB"); // 币种
        sfctb.setTb022(cmsmg.map(Cmsmg::getMg003).orElse(BigDecimal.ONE)); // 汇率
        sfctb.setTb023(outSfcta.getTa051()); // 移出部门
        sfctb.setTb024(""); // 移入部门
        // tb025
        // tb026
        // tb027
        // tb029
        // tb030
        sfctb.setTb031(mocta.getTa083()); // 项目编号

        Sfctc sfctc = new Sfctc();
        sfctc.setTc001(sfctb.getTb001()); // 转移单单别
        sfctc.setTc002(sfctb.getTb002()); // 转移单单号
        sfctc.setTc003("0001"); // 序号
        sfctc.setTc004(mocta.getTa001()); // 工单单别
        sfctc.setTc005(mocta.getTa002()); // 工单单号
        sfctc.setTc006(outSfcta.getTa003()); // 移出加工顺序
        sfctc.setTc007(outSfcta.getTa004()); // 移出工艺
        sfctc.setTc008(""); // 移入加工顺序
        sfctc.setTc009(""); // 移入工艺
        sfctc.setTc010(invmb.getMb004()); // 单位
        // tc011
        sfctc.setTc012(outSfcta.getTa020()); // 计价单位
        sfctc.setTc013(params.getTc013()); // 类型
        sfctc.setTc014(tc039.equals("0") ? params.getTc036() : BigDecimal.ZERO);
        sfctc.setTc015(sfctc.getTc014());
        // tc016
        sfctc.setTc017(outSfcta.getTa021()); // 委外单价
        sfctc.setTc018(sfctb.getTb004().trim().equals("2")? sfctc.getTc015().multiply(sfctc.getTc017()) : BigDecimal.ZERO); // 加工金额
        // tc019
        sfctc.setTc020(params.getTc020()); // 使用人时
        sfctc.setTc021(params.getTc021()); // 使用机时
        sfctc.setTc022("N"); // 审核码
        sfctc.setTc023(outSfcta.getTa006()); // 移出地
        sfctc.setTc024(currentDate); // 预交货日期
        // tc025
        sfctc.setTc026("N"); // 结束
        sfctc.setTc027("N"); // 超期码
        // tc028
        // tc029
        // tc030
        // tc031
        sfctc.setTc032(params.getTc032()); // 批号
        // tc033
        // tc034
        sfctc.setTc035("N"); // 急料
        sfctc.setTc036(params.getTc036()); // 转移数量
        // tc037
        sfctc.setTc038(currentDate); // 验收日期
        sfctc.setTc039(tc039); // 检验状态
        // tc040
        sfctc.setTc041(cmsmc.getMc001()); // 移入地
        // tc042
        // tc043
        // tc044
        // tc045
        // tc046
        sfctc.setTc047(mocta.getTa006()); // 产品品号
        sfctc.setTc048(mocta.getTa034()); // 产品品名
        sfctc.setTc049(mocta.getTa035()); // 产品规格
        // tc051
        // tc052
        // tc053
        sfctc.setTc054("N"); // 报废码
        // tc055
        sfctc.setTc056(params.getTc056()); // 库位
        // tc057
        sfctc.setTc058(currentDate); // 生产日期
        // tc059
        // tc060
        // tc061
        // tc062
        // tc063
        sfctc.setTcd01(currentActor.getActor().getMv001()); // 员工编号
        // tcd02
        sfctc.setTc064(mocta.getTa083()); // 项目编号

        sfctbDao.save(sfctb);
        sfctcDao.save(sfctc);
    }

    /**
     * 获取转移单检验信息
     * @param criteria 查询条件
     * @return
     */
    public List<SfctcDto> getForTransferCheck(SfctcTransferCheckCriteria criteria) {
        return sfctcDao.findAllByTc004AndTc005AndTc006AndTc008(criteria.getTc004(), criteria.getTc005(), criteria.getTc006(), criteria.getTc008())
                .stream()
                //.filter(i -> i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .filter(i -> i.getTc022().trim().equals("N"))
                .filter(i -> i.getTc014().add(i.getTc016()).add(i.getTc037()).compareTo(i.getTc036()) < 0)
                .map(sfctbMapper::toSfctcDto)
                .collect(Collectors.toList());
    }

    /**
     * 获取入库单检验信息
     * @param criteria 查询条件
     * @return
     */
    public List<SfctcDto> getForStorageCheck(SfctcStorageCheckCriteria criteria) {
        return sfctcDao.findAllByTc004AndTc005AndTc006AndTc056(criteria.getTc004(), criteria.getTc005(), criteria.getTc006(), criteria.getTc056())
                .stream()
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .filter(i -> i.getTc022().trim().equals("N"))
                .filter(i -> i.getTc014().add(i.getTc016()).add(i.getTc037()).compareTo(i.getTc036()) < 0)
                .map(sfctbMapper::toSfctcDto)
                .collect(Collectors.toList());
    }

    /**
     * 转移单/入库单 检验
     * @param params 检验参数
     */
    @Transactional
    public void check(SfctcCheckParams params) {
        Sfctc sfctc = sfctcDao.findById(new SfctcId(params.getTc001(), params.getTc002(), params.getTc003()))
                //.filter(i->i.getCompany().trim().equals(currentActor.getCompany().trim()))
                .filter(i -> i.getTc022().trim().equals("N"))
                .orElseThrow(() -> new TopsunitException("此条码已审核，无法检验"));
        if (params.getTc015().compareTo(params.getTc014()) > 0) {
            throw new TopsunitException("计价数量不能大于验收数量");
        }
        int finisedFlag = params.getTc014().add(params.getTc016()).add(sfctc.getTc037()).compareTo(sfctc.getTc036());
        if (finisedFlag > 0) {
            throw new TopsunitException("验收数量+验退数量+报废数量不能大于转移数量");
        }else if (finisedFlag == 0){
            if(params.getTc014().compareTo(sfctc.getTc036()) >= 0){
                sfctc.setTc039("2");
            }else {
                sfctc.setTc039("3");
            }
        }
        sfctbMapper.updateSfctc(params, sfctc);
        sfctc.setTc037(sfctc.getTc036().subtract(sfctc.getTc014()).subtract(sfctc.getTc016()));

        sfctbDao.findById(new SfctbId(params.getTc001(), params.getTc002())).ifPresent(i -> {
            if(i.getTb004().trim().equals("2")){
                sfctc.setTc018(sfctc.getTc015().multiply(sfctc.getTc017()));
            }
        });
    }

    private String getNewTG002() {
        String prefix = DateUtil.currentDateString();
        return sfctbDao.findFirstByTb002StartingWithOrderByTb002Desc(prefix)
                .map(i -> {
                    int currentOrdianl = Integer.parseInt(i.getTb002().replace(prefix, ""));
                    return prefix + String.format("%03d", currentOrdianl + 1);
                })
                .orElse(prefix + "001");
    }

    private BigDecimal getInProcessQuantity(Sfcta sfcta) {
        BigDecimal sfctcTc036Count = BigDecimal.ZERO;
        List<Sfctc> sfctcs = sfctcDao.findAllByTc004AndTc005AndTc006AndTc022(sfcta.getTa001(), sfcta.getTa002(), sfcta.getTa003(), "N")
                .stream()
                .filter(i -> {
                    String tc013 = i.getTc013().trim();
                    if (tc013.equals("1") || tc013.equals("2") || tc013.equals("4")) {
                        return true;
                    }
                    return false;
                })
                .collect(Collectors.toList());
        for (Sfctc sfctc : sfctcs) {
            sfctcTc036Count = sfctcTc036Count.add(sfctc.getTc036());
        }
        return sfcta.getTa010()
                .add(sfcta.getTa013())
                .add(sfcta.getTa016())
                .subtract(sfcta.getTa011())
                .subtract(sfcta.getTa012())
                .subtract(sfcta.getTa056())
                .subtract(sfcta.getTa014())
                .subtract(sfcta.getTa015())
                .subtract(sfctcTc036Count);
    }
}
