package com.topsunit.scanservice.ximai.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.entity.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 完工入库申请服务
 */
@Service
public class MoctfService {

    @Autowired
    private MoctfDao moctfDao;
    @Autowired
    private MoctgDao moctgDao;
    @Autowired
    private InvmbDao invmbDao;
    @Autowired
    private InvmcDao invmcDao;
    @Autowired
    private MoctaDao moctaDao;
    @Transactional
    public void create(MoctfCreateParams create){
        Moctf moctf = BeanUtil.toBeanIgnoreError(create, Moctf.class);
        Calendar curr = Calendar.getInstance();
        String currStr = DateUtil.format(curr.getTime(), "yyyyMMdd");
        moctf.setTf003(currStr);
        moctf.setTf012(currStr);
        AtomicReference<String> ta083 = new AtomicReference<String>();
        create.getDetails().forEach(s->{
            Moctg moctg = BeanUtil.toBeanIgnoreError(s, Moctg.class);
            //查询工单
            Mocta mocta = moctaDao.findById(new MoctaId(s.getTg014(), s.getTg015())).orElseThrow(()->new TopsunitException(String.format("未找到对应工单%s,%s",s.getTg014(),s.getTg015())));
            //查询物料
            Invmb invmb = invmbDao.findById(mocta.getTa006()).orElseThrow(()->new TopsunitException(String.format("未找到对应物料：%s", s.getTg004())));
            moctg.setTg004(invmb.getMb001());
            moctg.setTg005(invmb.getMb002());
            moctg.setTg006(invmb.getMb003());
            moctg.setTg007(invmb.getMb004());
            moctg.setTg037(invmb.getMb004());
            moctg.setTg010(invmb.getMb017());
            ta083.set(mocta.getTa083());
            //查询物料默认仓库
            Invmc invmc = invmcDao.findById(new InvmcId(invmb.getMb001(), invmb.getMb017())).orElseThrow(()->new TopsunitException(String.format("未找到对应物料默认库：%s,%s", invmb.getMb001(), invmb.getMb017())));
            moctg.setTg036(invmc.getMc015());
            moctg.setTg030(currStr);
            moctgDao.save(moctg);
        });
        moctf.setTf033(ta083.get());
        moctf.setTf023(create.getDetails().get(0).getTg011());
        moctf.setTf024(create.getDetails().get(0).getTg011());
        moctfDao.save(moctf);
    }
}
