package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.dao.CmsniDao;
import com.topsunit.scanservice.ximai.dto.CmsniCriteria;
import com.topsunit.scanservice.ximai.dto.CmsniDto;
import com.topsunit.scanservice.ximai.dto.mapper.CmsniMapper;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * <p>Title: CmsniService</p>
 * <p>Description: 仓库库位档 service</p>
 *
 * @author xi.feng
 * @version V1.0
 */
@Service
public class CmsniService {
    private final CmsniDao cmsniDao;
    private final CmsniMapper cmsniMapper;

    public CmsniService(CmsniDao cmsniDao, CmsniMapper cmsniMapper) {
        this.cmsniDao = cmsniDao;
        this.cmsniMapper = cmsniMapper;
    }

    public Optional<CmsniDto> getForScan(CmsniCriteria criteria){
        return cmsniDao.findFirstByNi002(criteria.getNi002())
                .map(cmsniMapper::toCmsniDto);
    }
}
