package com.topsunit.scanservice.ximai.security;

import com.topsunit.scanservice.ximai.dao.AdmmfDao;
import com.topsunit.scanservice.ximai.dao.CmsmvDao;
import com.topsunit.scanservice.ximai.entity.Cmsmv;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * <p>Title: CurrentActorManager</p>
 * <p>Description: 管理当前用户</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
@Component
@Scope(org.springframework.web.context.WebApplicationContext.SCOPE_REQUEST)
public class CurrentActorManager implements CurrentActorSetter {
    private Cmsmv cmsmv;
    private String company;
    private String usr_group;
    private final CmsmvDao cmsmvDao;
    private final AdmmfDao admmfDao;

    public CurrentActorManager(CmsmvDao cmsmvDao, AdmmfDao admmfDao) {
        this.cmsmvDao = cmsmvDao;
        this.admmfDao = admmfDao;
    }

    @Override
    public Cmsmv getActor() {
        return cmsmv;
    }

    @Override
    public void setActor(String id) {
        cmsmvDao.findById(id).ifPresent(i -> cmsmv = i);
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public String getCompany() {
        return this.company;
    }

    @Override
    public String getUsrGroup() {
        if (usr_group == null) {
            if (cmsmv != null) {
                usr_group = admmfDao.findFirstByMf001(cmsmv.getMv001())
                        .map(i->i.getMf004())
                        .orElse("");
            }
        }
        return usr_group;
    }
}
