package com.topsunit.scanservice.ximai.security;

import com.topsunit.scanservice.ximai.common.AppConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * <p>Title: AuthenticationInterceptor</p>
 * <p>Description: AuthenticationInterceptor</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
public class AuthenticationInterceptor implements HandlerInterceptor {

    @Autowired
    ApplicationContext applicationContext;

    @Autowired
    AppConfig appConfig;

    @Autowired
    TokenManger tokenManger;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {

        if(handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;

            if(handlerMethod.getBean() instanceof ErrorController) {
                return true;
            }

            Method method = handlerMethod.getMethod();
            if(method.isAnnotationPresent(PassToken.class)) {
                return true;
            }
        }

        String authorization = request.getHeader("Authorization");

        try {
            CheckAuthentication(authorization);
        }
        catch (RuntimeException e){
            if(!appConfig.getAuthenticationEnabled()){
                CurrentActorSetter currentActorSetter = applicationContext.getBean(CurrentActorSetter.class);
                currentActorSetter.setActor("CRMDS");
                currentActorSetter.setCompany("DEMO");
                return true;
            }
            else {
                response.sendError(401, e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void CheckAuthentication(String authorization){
        if(authorization == null || authorization.isEmpty()) {
            throw new RuntimeException("无Authorization，请登录");
        }
        if(!authorization.startsWith("Bearer ")) {
            throw new RuntimeException("不支持的验证方式，请使用Bearer Token");
        }

        String token = authorization.substring(7);
        TokenAudience tokenAudience = tokenManger.getTokenAudience(token);
        CurrentActorSetter currentActorSetter = applicationContext.getBean(CurrentActorSetter.class);
        currentActorSetter.setActor(tokenAudience.getActorId());
        currentActorSetter.setCompany(tokenAudience.getCompany());
    }
}
