package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: SfctbId</p>
 * <p>Description: 转移单单头档Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/28
 */
public class SfctbId implements Serializable {
    public SfctbId() {
    }

    public SfctbId(String tb001, String tb002) {
        this.tb001 = String.format("%1$-4s", tb001);
        this.tb002 = String.format("%1$-11s", tb002);
    }

    private String tb001;
    private String tb002;

    public String getTb001() {
        return tb001;
    }

    public void setTb001(String tb001) {
        this.tb001 = tb001;
    }

    public String getTb002() {
        return tb002;
    }

    public void setTb002(String tb002) {
        this.tb002 = tb002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SfctbId sfctbId = (SfctbId) o;
        return tb001.equals(sfctbId.tb001) && tb002.equals(sfctbId.tb002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tb001, tb002);
    }
}
