package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * <p>Title: Invmb</p>
 * <p>Description: 品号基本信息档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
@Data
@Entity
public class Invmb extends EntityBase {
    @Id
    @ApiModelProperty("品号")
    private String mb001;
    @ApiModelProperty("品名")
    private String mb002;
    @ApiModelProperty("规格")
    private String mb003;
    @ApiModelProperty("内部图号")
    private String udf07;
    @ApiModelProperty("库存单位")
    private String mb004;
    @ApiModelProperty("品号类别")
    private String mb005;
    /**
     * N:不需要、Y:需要不检查库存量、W:仅需警告、T:需要且检查库存量
     */
    @ApiModelProperty("批号管理")
    private String mb022;

    @ApiModelProperty("客户图号")
    private String mb029;

    /**
     * 0:免检、1:抽检(减量)、2:抽检(正常)、3:抽检(加严)、4:全检     //880820 MODI BY 551
     */
    @ApiModelProperty("检验方式")
    private String mb043;

    @ApiModelProperty("计价单位")
    private String mb149;
    @ApiModelProperty("客户品号")
    private String udf01;
    /**
     * 主要仓库
     */
    @ApiModelProperty("主要仓库")
    private String mb017;
    /**
     * Y:已核准、y:尚待核准、N:不准交易[DEF:"Y"]
     */
    @ApiModelProperty("核准状态")
    private String mb109;

    @ApiModelProperty("备注")
    private String mb028;

    @ApiModelProperty("MES同步标识")
    private String udf08;

    @ApiModelProperty("所属产线")
    private String udf05;
}
