package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.SfctbService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>Title: SfctbController</p>
 * <p>Description: 转移单 Controller</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/28
 */
@RestController
public class SfctbController {
    private final SfctbService sfctbService;

    public SfctbController(@RequestBody SfctbService sfctbService) {
        this.sfctbService = sfctbService;
    }

    @PostMapping("/sfctb/createfortransfer")
    public void createForTransfer(@RequestBody SfctbCreateParams params) {
        sfctbService.createForTransfer(params);
    }

    @PostMapping("/sfctb/createforstorage")
    public void createForStorage(@RequestBody SfctbCreateParams params) {
        sfctbService.createForStorage(params);
    }

    @PostMapping("/sfctb/getfortransfercheck")
    public List<SfctcDto> getForTransferCheck(@RequestBody SfctcTransferCheckCriteria criteria) {
        return sfctbService.getForTransferCheck(criteria);
    }

    @PostMapping("/sfctb/getforstoragecheck")
    public List<SfctcDto> getForStorageCheck(@RequestBody SfctcStorageCheckCriteria criteria) {
        return sfctbService.getForStorageCheck(criteria);
    }

    @PostMapping("/sfctb/check")
    public void check(@RequestBody SfctcCheckParams params) {
        sfctbService.check(params);
    }
}
