package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.PurccService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * <p>Title: PurccController</p>
 * <p>Description: 到货单</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
@RestController
@RequestMapping("/purcc")
public class PurccController {
    private final PurccService purccService;

    public PurccController(PurccService purccService) {
        this.purccService = purccService;
    }

    @PostMapping("/getforprint")
    public Optional<PurccDto> getForPrint(@RequestBody PurccIdCriteria criteria) {
        return purccService.getForPrint(criteria);
    }

    @PostMapping("/print")
    public void print(@RequestBody PurccPrintParams purccPrintParams) {
        purccService.print(purccPrintParams);
    }

    @PostMapping("/getforcheck")
    public Optional<PurccDto> getForCheck(@RequestBody PurccIdCriteria criteria) {
        return purccService.getForCheck(criteria);
    }

    @PostMapping("/check")
    public void check(@RequestBody PurccCheckParams purccCheckParams) {
        purccService.check(purccCheckParams);
    }
}
