package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.MocthService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * <p>Title: MocthController</p>
 * <p>Description: 委外进货单</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/27
 */
@RestController
public class MocthController {
    private final MocthService mocthService;

    public MocthController(MocthService mocthService) {
        this.mocthService = mocthService;
    }

    @PostMapping("/mocth/getforprint")
    public Optional<MocthDto> getForPrint(@RequestBody MocthIdCriteria criteria){
        return mocthService.getForPrint(criteria);
    }

    @PostMapping("/mocth/getforcheck")
    public Optional<MocthDto> getForCheck(@RequestBody MocthIdCriteria criteria){
        return mocthService.getForCheck(criteria);
    }

    @PostMapping("/mocth/getforputon")
    public Optional<MocthDto> getForPutOn(@RequestBody MocthIdCriteria criteria){
        return mocthService.getForPutOn(criteria);
    }

    @PostMapping("/mocth/print")
    public void print(@RequestBody MocthPrintParams printParams){
        mocthService.print(printParams);
    }

    @PostMapping("/mocth/check")
    public void check(@RequestBody MocthCheckParams checkParams){
        mocthService.check(checkParams);
    }

    @PostMapping("/mocth/puton")
    public void putOn(@RequestBody MocthPutOnParams putOnParams){
        mocthService.putOn(putOnParams);
    }
}
