package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.MoctcService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * Author:   Jack
 * Date:     2021/10/29 22:25
 * Description: 领/退料单
 */
@RestController
public class MoctcController {
    private final MoctcService moctcService;

    public MoctcController(MoctcService moctcService) {
        this.moctcService = moctcService;
    }

    @PostMapping("/moctc/getforcreate")
    public Optional<MoctcCreateDto> getForCreate(@RequestBody MoctcCreateCriteria criteria) {
        return moctcService.getForCreate(criteria);
    }

    @PostMapping("/moctc/create")
    public void create(@RequestBody MoctcCreateParams moctcCreateParams) {
        moctcService.create(moctcCreateParams);
    }
}
