package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.MoctaService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * <p>Title: MoctaController</p>
 * <p>Description: 工单单头</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/16
 */
@RestController
public class MoctaController {

    private final MoctaService moctaService;

    public MoctaController(MoctaService moctaService) {
        this.moctaService = moctaService;
    }

    @PostMapping("/mocta/getfordoc")
    Optional<MoctaDocDto> getForDoc(@RequestBody MoctaIdCriteria criteria){
        return moctaService.getForDoc(criteria);
    }

    @ApiOperation("工单查询")
    @PostMapping("/mocta/getMoctaList")
    List<MoctaDto> getMoctaList(@RequestBody MoctaCriteria criteria){
        return moctaService.getMoctaList(criteria);
    }
    @ApiOperation("工单材料查询")
    @PostMapping("/moctb/getMoctbList")
    List<MoctbDto> getMoctaList(@RequestBody MoctbCriteria criteria){
        return moctaService.getMoctbList(criteria);
    }

    @ApiOperation("工单MES更新标识")
    @PostMapping("/mocta/syncMark")
    void updateSyncMark(@RequestBody MoctaUpdateParams params){
        moctaService.updateSyncMark(params);
    }

    @ApiOperation("工单状态更新")
    @PostMapping("/mocta/updateState")
    void updateState(@RequestBody MoctaUpdateParams params){
        moctaService.updateState(params);
    }


}
