package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.InvmbService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * <p>Title: InvmbController</p>
 * <p>Description: 品号基本信息档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/11
 */
@RestController
public class InvmbController {
    private final InvmbService invmbService;

    public InvmbController(InvmbService invmbService) {
        this.invmbService = invmbService;
    }

    @PostMapping("/invmb/getforinvmbinfo")
    public Optional<InvmbDto> getForInvmbInfo(@RequestBody InvmbIdCriteria criteria) {
        return invmbService.getForInvmbInfo(criteria);
    }

    @ApiOperation("查询物料列表")
    @PostMapping("/invmb/getInvmbList")
    public List<InvmbDto> getInvmbList(@RequestBody InvmbCriteria criteria) {
        return invmbService.getInvmbList(criteria);
    }

    @ApiOperation("物料MES更新标识")
    @PostMapping("/invmb/syncMark")
    public void syncMark(@RequestBody InvmbUpdateParams updateParams){
        invmbService.syncMark(updateParams);
    }

    @ApiOperation("查询物料分类")
    @PostMapping("/invma/getInvmaList")
    public List<InvmaDto> getInvmaList(@RequestBody InvmaCriteria criteria){
        return invmbService.getInvmaList(criteria);
    }

}
