package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.CmsniCriteria;
import com.topsunit.scanservice.ximai.dto.CmsniDto;
import com.topsunit.scanservice.ximai.service.CmsniService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

/**
 * <p>Title: CmsniController</p>
 * <p>Description: 仓库库位档 Controller</p>
 *
 * @author xi.feng
 * @version V1.0
 */
@RestController
public class CmsniController {
    private final CmsniService cmsniService;

    public CmsniController(CmsniService cmsniService) {
        this.cmsniService = cmsniService;
    }

    @PostMapping("/cmsni/getforscan")
    public Optional<CmsniDto> getForScan(@RequestBody CmsniCriteria criteria){
        return cmsniService.getForScan(criteria);
    }
}
