package com.topsunit.scanservice.ximai.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>Title: DateUtil</p>
 * <p>Description: DateUtil</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/25
 */
public class DateUtil {
    public static final  DateTimeFormatter defaultDateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final  DateTimeFormatter defaultDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    public static String localDateToString(LocalDate date){
        return date.format(defaultDateFormatter);
    }

    public static String currentDateString(){
        return LocalDate.now().format(defaultDateFormatter);
    }

    public static String localDateTimeToString(LocalDateTime dateTime){
        return dateTime.format(defaultDateTimeFormatter);
    }

    public static String currentDateTimeString(){
        return LocalDateTime.now().format(defaultDateTimeFormatter);
    }
}
