package com.topsunit.scanservice.ximai.common;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * <p>Title: AppConfig</p>
 * <p>Description: 配置文件读yml</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
@Configuration
public class AppConfig {
    @Value("${topsunit.token-expires-hour}")
    private Long tokenExpiresHour;

    public Long getTokenExpires() {
        if(tokenExpiresHour == null) {
            return (long) (60* 60 * 1000);
        }
        return tokenExpiresHour * 60 * 60 * 1000;
    }

    @Value("${topsunit.authentication-enabled}")
    private Boolean authenticationEnabled;

    public  boolean getAuthenticationEnabled(){
        if(authenticationEnabled == null){
            return true;
        }
        return authenticationEnabled;
    }

    @Value("${topsunit.print-api-url}")
    private String printApiUrl;

    public String getPrintApiUrl(){
        return printApiUrl;
    }

    @Value("${topsunit.default-password}")
    private String defaultPassword;

    public String getDefaultPassword(){
        return defaultPassword;
    }
}
