package com.topsunit.scanservice.ximai.webapi;

import com.topsunit.scanservice.ximai.webapi.dto.StorageDetailRecordCreate;
import com.topsunit.scanservice.ximai.webapi.dto.StorageDetailRecordResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <p>Title: MesStorageDetailRecordService</p>
 * <p>Description: MES 入库明细记录服务</p>
 *
 * @author generator
 * @version V1.0
 * @date 2025-10-12
 */
@FeignClient(name = "MES-StorageDetailRecord", url = "${topsunit.mes-url}")
public interface MesStorageDetailRecordService {
    
    /**
     * 新增入库明细记录（内部接口，无权限验证）
     *
     * @param storageDetailRecordCreate 入库明细记录创建对象
     * @return 操作结果
     */
    @RequestMapping(value = "/pro/storageDetailRecord/internal", method = RequestMethod.POST)
    StorageDetailRecordResult create(@RequestBody StorageDetailRecordCreate storageDetailRecordCreate);
}

