package com.topsunit.scanservice.ximai.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * <p>Title: AuthenticationConfigurer</p>
 * <p>Description: AuthenticationConfigurer</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
@Configuration
public class AuthenticationConfigurer implements WebMvcConfigurer {
    @Autowired
    AuthenticationInterceptor authenticationInterceptor;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(authenticationInterceptor)
                .addPathPatterns("/**");

        WebMvcConfigurer.super.addInterceptors(registry);

    }

    @Bean
    public AuthenticationInterceptor getAuthenticationInterceptor() {
        return new AuthenticationInterceptor();
    }
}
