package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * 出货通知单头档
 */
@Data
@IdClass(CoptnId.class)
@Entity
public class Coptn extends EntityBase{
    @Id
    @ApiModelProperty("通知单别")
    private String tn001;
    @Id
    @ApiModelProperty("通知单号")
    private String tn002;
    @ApiModelProperty("通知日期")
    private String tn003;
    @ApiModelProperty("客户编号")
    private String tn004;
    @ApiModelProperty("复核者")
    private String tn005;
    @ApiModelProperty("部门编号")
    private String tn006;
    @ApiModelProperty("业务人员")
    private String tn007;
    @ApiModelProperty("送货客户")
    private String tn008;
    @ApiModelProperty("送货地址(一)")
    private String tn009;
    @ApiModelProperty("送货地址(二)")
    private String tn010;
    @ApiModelProperty("税种 1.应税内含、2.应税外加、3.零税率、4.免税、9.不计税")
    private String tn011;
    @ApiModelProperty("备注")
    private String tn012;
    @ApiModelProperty("币种")
    private String tn013;
    @ApiModelProperty("汇率 //20030324 modi by 29618 7.4->10.7")
    private BigDecimal tn014;
    @ApiModelProperty("销货金额")
    private BigDecimal tn015;
    @ApiModelProperty("本单已否审核的判断码(y/n)")
    private String tn016;
    @ApiModelProperty("工厂")
    private String tn017;
    @ApiModelProperty("复核日期")
    private String tn018;
    @ApiModelProperty("销货税额")
    private BigDecimal tn019;
    @ApiModelProperty("打印次数")
    private Integer tn020;
    @ApiModelProperty("单据日期[formate:ymd]")
    private String tn021;
    @ApiModelProperty("审核者")
    private String tn022;
    @ApiModelProperty("付款条件编号")
    private String tn023;
    @ApiModelProperty("0.待处理、1.签核中、2.退件、3.已核准、4.撤销审核中、5.作废中、6.取消作废中、n.不运行电子签核")
    private String tn024;
    @ApiModelProperty("海关手册")
    private String tn025;
    @ApiModelProperty("生成分录")
    private String tn026;
    @ApiModelProperty("质量状况")
    private String tn027;
    @ApiModelProperty("出货人")
    private String tn028;
    @ApiModelProperty("传送次数[def:0]   //20030424 add by 28985 for p00-03040011")
    private Integer tn029;
    @ApiModelProperty("税率(%)")
    private BigDecimal tn030;
}
