package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.CmsmcCriteria;
import com.topsunit.scanservice.ximai.dto.CmsmcDto;
import com.topsunit.scanservice.ximai.dto.CmsniCriteria;
import com.topsunit.scanservice.ximai.dto.CmsniDto;
import com.topsunit.scanservice.ximai.service.CmsmcService;
import com.topsunit.scanservice.ximai.service.CmsniService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * <p>Title: CmsmcController</p>
 * <p>Description: 仓库库位档 Controller</p>
 *
 * @author chicheng.li
 * @version V1.0
 */
@RestController
public class CmsmcController {
    @Autowired
    private CmsmcService cmsmcService;

    @ApiOperation("查询仓库列表")
    @PostMapping("/cmsmc/getCmsmcList")
    public List<CmsmcDto> getCmsmcList(@RequestBody CmsmcCriteria criteria){
        return cmsmcService.getCmsmcList(criteria);
    }
}
