package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurtbId</p>
 * <p>Description: PurtbId</p>
 *
 * @author xi.feng
 * @version V1.0
 */
@Data
public class PurtbId implements Serializable {

    public PurtbId() {
    }

    public PurtbId(String tb001, String tb002, String tb003) {
        this.tb001 = String.format("%1$-20s", tb001);
        this.tb002 = String.format("%1$-4s", tb002);
    }

    /**
     * 单别
     */
    @ApiModelProperty("单别")
    private String tb001;

    /**
     * 单号
     */
    @ApiModelProperty("单号")
    private String tb002;

    /**
     * 序号
     */
    @ApiModelProperty("序号")
    private String tb003;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurtbId id = (PurtbId) o;
        return tb001.equals(id.tb001) && tb002.equals(id.tb002) && tb003.equals(id.tb003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tb001, tb002, tb003);
    }
}
