package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Moctf</p>
 * <p>Description: 生产入库单头档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/23
 */
@Data
@Entity
@IdClass(MoctfId.class)
public class Moctf extends EntityBase {
    @Id
    @ApiModelProperty("入库单别")
    private String tf001;
    /**
     * S+yyMMddxxxx
     */
    @Id
    @ApiModelProperty("入库单号")
    private String tf002;

    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private String tf003;

    @ApiModelProperty("工厂编号")
    private String tf004;

    @ApiModelProperty("备注")
    private String tf005;

    @ApiModelProperty("审核码")
    private String tf006;

    @ApiModelProperty("生产记录更新码")
    private String tf007;

    @ApiModelProperty("生成分录-成本")
    private String tf010;

    @ApiModelProperty("签核状态码")
    private String tf014;

    @ApiModelProperty("自动扣料更新码")
    private String tf009;

    @ApiModelProperty("工作中心")
    private String tf011;
    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    private String tf012;

    @ApiModelProperty("部门")
    private String tf016;

    /**
     * 总入库数
     */
    @ApiModelProperty("总入库数")
    private BigDecimal tf023;

    /**
     * 总验收数
     */
    @ApiModelProperty("总验收数")
    private BigDecimal tf024;

    @ApiModelProperty("项目编号")
    private String tf033;

}
