package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 库存盘点参数
 */
@Data
public class StockTakingParams {

    @ApiModelProperty("盘点明细")
    List<StockTakingDetail> data;

    @Data
    public static class StockTakingDetail{
        @ApiModelProperty("物料号")
        String materialNo;
        @ApiModelProperty("物料名称")
        String materialName;
        @ApiModelProperty("仓库")
        String warehouse;
        @ApiModelProperty("储位")
        String location;
        @ApiModelProperty("批号")
        String batchNo;
        @ApiModelProperty("库存数量")
        BigDecimal stockQuantity;
        @ApiModelProperty("盘点数量")
        BigDecimal physicalQuantity;
        @ApiModelProperty("是否新增")
        int isAppend=0;
    }
}
