package com.topsunit.scanservice.ximai.dto;

import com.topsunit.scanservice.ximai.entity.EntityBase;
import com.topsunit.scanservice.ximai.entity.PurccId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>Title: Purcc</p>
 * <p>Description: 到货单单头档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
@Data
public class PurccCreateParams  {
    @ApiModelProperty("单别")
    private String cc001;
    @ApiModelProperty("单号")
    private String cc002;
    @ApiModelProperty("日期")
    private String cc003;
    @ApiModelProperty("工厂编码")
    private String cc004;
    @ApiModelProperty("供货商号")
    private String cc005;
    @ApiModelProperty("")
    private String cc006="";
    @ApiModelProperty("打印方式")
    private String cc008="1";
    @ApiModelProperty("审核状态")
    private String cc009="N";
    @ApiModelProperty("单据日期")
    private String cc010;
    @ApiModelProperty("")
    private String cc011="";
    @ApiModelProperty("供货商名称")
    private String cc012;
    @ApiModelProperty("表身到货总数量")
    private BigDecimal cc013;
    @ApiModelProperty("")
    private String cc026="";
    @ApiModelProperty("库房标识")
    private String udf01;
    @ApiModelProperty("到货明细")
    List<PurcdCreateParams> detailList=new ArrayList<>();
}
