package com.topsunit.scanservice.ximai.service;

import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.common.OrdinalHelper;
import com.topsunit.scanservice.ximai.common.StringUtil;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dao.*;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.dto.mapper.PurmaMapper;
import com.topsunit.scanservice.ximai.dto.mapper.PurtgMapper;
import com.topsunit.scanservice.ximai.entity.*;
import com.topsunit.scanservice.ximai.security.CurrentActor;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>Title: PurmaService</p>
 * <p>Description: 供应商服务</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/16
 */
@Service
public class PurmaService {
    private final CurrentActor currentActor;
    private final CmsmgDao cmsmgDao;
    private final InvmbDao invmbDao;
    private final InvmcDao invmcDao;
    private final InvmeDao invmeDao;
    private final PurccDao purccDao;
    private final PurcdDao purcdDao;
    private final PurtcDao purtcDao;
    private final PurtdDao purtdDao;
    private final PurtgDao purtgDao;
    private final PurthDao purthDao;
    private final PurmaDao purmaDao;
    private final CmsniDao cmsniDao;
    private final PurtgMapper purtgMapper;
    @Autowired
    private PurmaMapper purmaMapper;

    public PurmaService(CurrentActor currentActor, CmsmgDao cmsmgDao, InvmbDao invmbDao, InvmcDao invmcDao, InvmeDao invmeDao, PurccDao purccDao, PurcdDao purcdDao, PurtcDao purtcDao, PurtdDao purtdDao, PurtgDao purtgDao, PurthDao purthDao, PurmaDao purmaDao, CmsniDao cmsniDao, PurtgMapper purtgMapper) {
        this.currentActor = currentActor;
        this.cmsmgDao = cmsmgDao;
        this.invmbDao = invmbDao;
        this.invmcDao = invmcDao;
        this.invmeDao = invmeDao;
        this.purccDao = purccDao;
        this.purcdDao = purcdDao;
        this.purtcDao = purtcDao;
        this.purtdDao = purtdDao;
        this.purtgDao = purtgDao;
        this.purthDao = purthDao;
        this.purmaDao = purmaDao;
        this.cmsniDao = cmsniDao;
        this.purtgMapper = purtgMapper;
    }

    public List<PurmaDto> getPurmaDtoList(PurmaCriteria criteria) {
        Specification<Purma> query = new Specification<Purma>() {
            @Override
            public Predicate toPredicate(Root<Purma> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicates = new ArrayList<Predicate>();
                if (StringUtils.isNotBlank(criteria.getMa001())) {
                    Predicate predicate = criteriaBuilder.like(root.get("ma001"), criteria.getMa001() + "%");
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMa002())) {
                    Predicate predicate = criteriaBuilder.like(root.get("ma002"), criteria.getMa002() + "%");
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMa003())) {
                    Predicate predicate = criteriaBuilder.like(root.get("ma003"), criteria.getMa003() + "%");
                    predicates.add(predicate);
                }
                if (StringUtils.isNotBlank(criteria.getMa016())) {
                    Predicate predicate = criteriaBuilder.equal(root.get("ma016"), criteria.getMa016());
                    predicates.add(predicate);
                }
                return criteriaQuery.where(predicates.toArray(new Predicate[0])).getRestriction();
            }
        };
        List<Purma> list = purmaDao.findAll(query);
        return purmaMapper.toPurmaDtoList(list);
    }

}
