package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Purta</p>
 * <p>Description: 请购单单头信息档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Data
@Entity
@IdClass(PurtaId.class)
public class Purta extends EntityBase {
    @Id
    @ApiModelProperty("请购单别")
    private String ta001;
    @Id
    @ApiModelProperty("请购单号")
    private String ta002;
    @ApiModelProperty("请购日期")
    private String ta003;
    @ApiModelProperty("请购部门")
    private String ta004;
    @ApiModelProperty("审核码")
    private String ta007;
    @ApiModelProperty("数量合计")
    private BigDecimal ta011;
    @ApiModelProperty("来源")
    private String ta009;
    @ApiModelProperty("工厂")
    private String ta010;
    @ApiModelProperty("客户订单号")
    private String udf02;
    @ApiModelProperty("销售单号")
    private String udf03;
    @ApiModelProperty("单据日期")
    private String ta013;
    @ApiModelProperty("备注")
    private String ta006;
}
