package com.topsunit.scanservice.ximai.barcode.controller;

import com.topsunit.scanservice.ximai.barcode.dto.ATCstDsDto;
import com.topsunit.scanservice.ximai.barcode.dto.BoxCodeQueryResultDto;
import com.topsunit.scanservice.ximai.barcode.service.ATCstDsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>Title: ATCstDsController</p>
 * <p>Description: 派工明细控制器</p>
 *
 * @author system
 * @version V1.0
 * @date 2025/01/23
 */
@Api(tags = "派工明细管理")
@RestController
@RequestMapping("/barcodeSystem/atcstds")
public class ATCstDsController {

    @Autowired
    private ATCstDsService atCstDsService;

    @ApiOperation("根据ID获取派工明细信息")
    @GetMapping("/{id}")
    public ATCstDsDto getById(@ApiParam("主键ID") @PathVariable String id) {
        return atCstDsService.getById(id);
    }

    @ApiOperation("获取派工明细列表")
    @GetMapping("/list")
    public Page<ATCstDsDto> getList(
            @ApiParam("查询条件") ATCstDsDto criteria,
            @ApiParam("页码") @RequestParam(defaultValue = "0") int page,
            @ApiParam("每页大小") @RequestParam(defaultValue = "10") int size) {
        return atCstDsService.getList(criteria, page, size);
    }

    @ApiOperation("保存派工明细信息")
    @PostMapping
    public ATCstDsDto save(@ApiParam("派工明细信息") @RequestBody ATCstDsDto dto) {
        return atCstDsService.save(dto);
    }

    @ApiOperation("更新派工明细信息")
    @PutMapping
    public ATCstDsDto update(@ApiParam("派工明细信息") @RequestBody ATCstDsDto dto) {
        return atCstDsService.update(dto);
    }

    @ApiOperation("删除派工明细信息")
    @DeleteMapping("/{id}")
    public String delete(@ApiParam("主键ID") @PathVariable String id) {
        return atCstDsService.delete(id);
    }

    @ApiOperation("通过箱码查询小标签条码")
    @GetMapping("/queryByBoxCode")
    public List<BoxCodeQueryResultDto> getSmallLabelBarcodesByBoxCode(
            @ApiParam("箱码") @RequestParam String boxCode) {
        return atCstDsService.getSmallLabelBarcodesByBoxCode(boxCode);
    }
}
