package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurccId</p>
 * <p>Description: 到货单单头档主键</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
public class PurccId implements Serializable {
    public PurccId() {
    }

    public PurccId(String cc001, String cc002) {
        this.cc001 = String.format("%1$-4s", cc001);
        this.cc002 = String.format("%1$-11s", cc002);
    }

    private String cc001;
    private String cc002;

    public String getCc001() {
        return cc001;
    }

    public void setCc001(String cc001) {
        this.cc001 = cc001;
    }

    public String getCc002() {
        return cc002;
    }

    public void setCc002(String cc002) {
        this.cc002 = cc002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurccId purccId = (PurccId) o;
        return cc001.equals(purccId.cc001) && cc002.equals(purccId.cc002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cc001, cc002);
    }
}
