package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: MoctiId</p>
 * <p>Description: 委外进货单身档</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/27
 */
public class MoctiId implements Serializable {
    public MoctiId() {
    }

    public MoctiId(String ti001, String ti002, String ti003) {
        this.ti001 = String.format("%1$-4s", ti001);
        this.ti002 = String.format("%1$-11s", ti002);
        this.ti003 = String.format("%1$-4s", ti003);
    }

    private String ti001;
    private String ti002;
    private String ti003;

    public String getTi001() {
        return ti001;
    }

    public void setTi001(String ti001) {
        this.ti001 = ti001;
    }

    public String getTi002() {
        return ti002;
    }

    public void setTi002(String ti002) {
        this.ti002 = ti002;
    }

    public String getTi003() {
        return ti003;
    }

    public void setTi003(String ti003) {
        this.ti003 = ti003;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MoctiId moctiId = (MoctiId) o;
        return ti001.equals(moctiId.ti001) && ti002.equals(moctiId.ti002) && ti003.equals(moctiId.ti003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ti001, ti002, ti003);
    }
}
