package com.topsunit.scanservice.ximai.dto.mapper;

import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.entity.Mocth;
import com.topsunit.scanservice.ximai.entity.MocthId;
import com.topsunit.scanservice.ximai.entity.Mocti;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

import java.util.List;

/**
 * <p>Title: MocthMapper</p>
 * <p>Description: 委外进货单映射</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/27
 */
@Mapper(componentModel = "spring")
public interface MocthMapper {
    MocthId toMocthId(MocthIdCriteria criteria);
    MocthId toMocthId(MocthCheckParams checkParams);
    MocthId toMocthId(MocthPutOnParams putOnParams);
    MocthDto toMocthDto(Mocth mocth);
    MoctiDto toMoctiDto(Mocti mocti);
    List<MoctiDto> toMoctiDto(List<Mocti> moctis);
    @Mapping(target = "ti001", ignore = true)
    @Mapping(target = "ti002", ignore = true)
    @Mapping(target = "ti003", ignore = true)
    void updateMocti(MoctiCheckParams checkParams, @MappingTarget Mocti mocti);
    @Mapping(target = "ti001", ignore = true)
    @Mapping(target = "ti002", ignore = true)
    @Mapping(target = "ti003", ignore = true)
    void updateMocti(MoctiPutOnParams putOnParams, @MappingTarget Mocti mocti);
}
