package com.topsunit.scanservice.ximai.common;

/**
 * <p>Title: ServiceResult</p>
 * <p>Description: 标准数据返回格式</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/19
 */
public class ServiceResult <TReturn>{

    /*
    interface ErrorInfoStructure {
  success: boolean; // if request is success
  data?: any; // response data
  errorCode?: string; // code for errorType
  errorMessage?: string; // message display to user
  showType?: number; // error display type： 0 silent; 1 message.warn; 2 message.error; 4 notification; 9 page
  traceId?: string; // Convenient for back-end Troubleshooting: unique request ID
  host?: string; // Convenient for backend Troubleshooting: host of current access server
}
     */
    private boolean success;
    private TReturn data;
    private String errorCode;
    private String errorMessage;
    private Integer showType;
    private String traceId;
    private String host;


    public static <TReturn> ServiceResult<TReturn> ofResult(TReturn data){
        ServiceResult<TReturn> serviceResult = new ServiceResult<>();
        serviceResult.success = true;
        serviceResult.data = data;
        return serviceResult;
    }

    @SuppressWarnings("rawtypes")
    public static ServiceResult Ok(){
        ServiceResult<Object> serviceResult = new ServiceResult<>();
        serviceResult.success = true;
        return serviceResult;
    }

    @SuppressWarnings("rawtypes")
    public static ServiceResult ofException(Exception exception){
        ServiceResult<Object> serviceResult = new ServiceResult<>();
        if(exception instanceof TopsunitException){
            TopsunitException topEx = (TopsunitException) exception;
            serviceResult.errorCode = topEx.getCode();
        }
        serviceResult.success = false;
        String msg = exception.getMessage();
        if(msg == null || msg.isEmpty()){
            serviceResult.errorMessage = "系统错误";
        }else {
            serviceResult.errorMessage = exception.getMessage();
        }
        return serviceResult;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public TReturn getData() {
        return data;
    }

    public void setData(TReturn data) {
        this.data = data;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getShowType() {
        return showType;
    }

    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}
