package com.topsunit.scanservice.ximai.barcode.dao;

import com.topsunit.scanservice.ximai.barcode.entity.ATCstDm;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * <p>Title: ATCstDmDao</p>
 * <p>Description: 在线标签打印数据访问接口</p>
 *
 * @author system
 * @version V1.0
 * @date 2025/01/23
 */
public interface ATCstDmDao extends JpaRepository<ATCstDm, String>, JpaSpecificationExecutor<ATCstDm> {

    /**
     * 根据箱码查询记录（显式按实体字段 pSNNo 查询，避免命名解析大小写问题）
     */
    @Query("select d from ATCstDm d where d.psnno = ?1")
    List<ATCstDm> findByPSNNo(String pSNNo);
}
