package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: PurtgId</p>
 * <p>Description: 进货单单头档主键</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/25
 */
public class PurtgId implements Serializable {
    public PurtgId() {
    }

    public PurtgId(String tg001, String tg002) {
        this.tg001 = String.format("%1$-4s", tg001);
        this.tg002 = String.format("%1$-11s", tg002);
    }

    private String tg001;
    private String tg002;

    public String getTg001() {
        return tg001;
    }

    public void setTg001(String tg001) {
        this.tg001 = tg001;
    }

    public String getTg002() {
        return tg002;
    }

    public void setTg002(String tg002) {
        this.tg002 = tg002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PurtgId purtgId = (PurtgId) o;
        return tg001.equals(purtgId.tg001) && tg002.equals(purtgId.tg002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tg001, tg002);
    }
}
