package com.topsunit.scanservice.ximai.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.math.BigDecimal;

/**
 * <p>Title: Moctg</p>
 * <p>Description: 生产入库单身档</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/23
 */
@Data
@Entity
@IdClass(MoctgId.class)
public class Moctg extends EntityBase {
    @Id
    @ApiModelProperty("入库单别")
    private String tg001;
    @Id
    @ApiModelProperty("入库单号")
    private String tg002;
    @Id
    @ApiModelProperty("序号")
    private String tg003;
    /**
     * 产品品号
     */
    @ApiModelProperty("产品品号")
    private String tg004;
    /**
     * 品名
     */
    @ApiModelProperty("品名")
    private String tg005;
    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String tg006;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String tg007;

    @ApiModelProperty("入/出别")
    private Integer tg009;
    /**
     * tg010
     */
    @ApiModelProperty("仓库")
    private String tg010;
    @ApiModelProperty("库位")
    private String tg036;
    @ApiModelProperty("库存单位")
    private String tg037;
    @ApiModelProperty("入库数量")
    private BigDecimal tg011;

    @ApiModelProperty("审核码")
    private String tg022;

    @ApiModelProperty("库存数量")
    private BigDecimal tg038;
    /**
     * 工单单别
     */
    @ApiModelProperty("工单单别")
    private String tg014;
    /**
     * 工单单号
     */
    @ApiModelProperty("工单单号")
    private String tg015;
    @ApiModelProperty("检验状态")
    private String tg016="0";
    @ApiModelProperty("急料")
    private String tg024;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private String tg030;
    @ApiModelProperty("报废数量")
    private BigDecimal tg012;
    @ApiModelProperty("验退数量")
    private BigDecimal tg023;
    @ApiModelProperty("破坏数量")
    private BigDecimal tg032;
    @ApiModelProperty("验收数量")
    private BigDecimal tg013;

}
