package com.topsunit.scanservice.ximai.dto;

import com.topsunit.scanservice.ximai.common.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * <p>Title: PurthCreateParams</p>
 * <p>Description: 录入进货单身参数</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/25
 */
@Data
public class PurthCreateParams {
    @ApiModelProperty("进货单别")
    private String cd001;
    @ApiModelProperty("进货单号")
    private String cd002;
    @ApiModelProperty("进货序号")
    private String cd003;
    @ApiModelProperty("仓库")
    private String th009 = "";
    @ApiModelProperty("原币单位金价")
    private String th010 = "";
    @ApiModelProperty("验收数量，默认进货数-入库数")
    private BigDecimal th015 = BigDecimal.ZERO;
    @ApiModelProperty("计价数量，默认进货数-入库数")
    private BigDecimal th016 = BigDecimal.ZERO;
    @ApiModelProperty("验退数量，默认0")
    private BigDecimal th017 = BigDecimal.ZERO;
    @ApiModelProperty("库位")
    private String th072 = "";

}
