package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Id;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>Title: MoctgCreateParams</p>
 * <p>Description: 完工入库申请表身</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/22
 */
@Data
public class MoctgCreateParams {

    @ApiModelProperty("入库单别")
    private String tg001="5801";
    @ApiModelProperty("入库单号")
    private String tg002;
    @ApiModelProperty("序号")
    private String tg003="0001";
    /**
     * 产品品号
     */
    @ApiModelProperty("产品品号")
    private String tg004;
    @ApiModelProperty("品名")
    private String tg005;
    @ApiModelProperty("规格")
    private String tg006;
    @ApiModelProperty("单位")
    private String tg007;
    @ApiModelProperty("入/出别")
    private Integer tg009=1;
    @ApiModelProperty("仓库")
    private String tg010;
    @ApiModelProperty("审核码")
    private String tg022="N";
    @ApiModelProperty("库位")
    private String tg036;
    @ApiModelProperty("库存单位")
    private String tg037;
    @ApiModelProperty("入库数量")
    private BigDecimal tg011;
    @ApiModelProperty("工单单别")
    private String tg014;
    @ApiModelProperty("工单单号")
    private String tg015;
    @ApiModelProperty("检验状态")
    private String tg016="0";
    @ApiModelProperty("急料")
    private String tg024;
    @ApiModelProperty("生产日期")
    private String tg030;
    @ApiModelProperty("报废数量")
    private BigDecimal tg012=BigDecimal.ZERO;
    @ApiModelProperty("验退数量")
    private BigDecimal tg023=BigDecimal.ZERO;
    @ApiModelProperty("破坏数量")
    private BigDecimal tg032=BigDecimal.ZERO;
    @ApiModelProperty("验收数量")
    private BigDecimal tg013;

}
