package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.common.AppConfig;
import com.topsunit.scanservice.ximai.common.FileView;
import com.topsunit.scanservice.ximai.common.IOUtils;
import com.topsunit.scanservice.ximai.common.SmbFileSystem;
import com.topsunit.scanservice.ximai.dto.*;
import com.topsunit.scanservice.ximai.service.MoctaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;

/**
 * <p>Title: MoctaController</p>
 * <p>Description: 工单单头</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/16
 */
@RestController
public class MoctaController {

    private final MoctaService moctaService;
    private AppConfig appConfig;

    public MoctaController(MoctaService moctaService) {
        this.moctaService = moctaService;
    }

    @PostMapping("/mocta/getfordoc")
    Optional<MoctaDocDto> getForDoc(@RequestBody MoctaIdCriteria criteria){
        return moctaService.getForDoc(criteria);
    }

    @ApiOperation("获取文件列表")
    @PostMapping("/mocta/getfordocList")
    MoctaDocDto getfordocList(@RequestBody MoctaIdCriteria criteria){
        MoctaDocDto rst = new MoctaDocDto();
        SmbFileSystem fileSystem = new SmbFileSystem();
        fileSystem.setUri(appConfig.getShareUrl());
        List<FileView> list = fileSystem.searchFiles("/", ".*",false);
        list.forEach(s->{
            rst.getFiles().add(s.getName());
        });
        return rst;
    }
    @ApiOperation("下载文件")
    @PostMapping("/mocta/getfordocFile")
    void getfordocFile(@RequestBody MoctaDocCriteria criteria, HttpServletResponse response) throws IOException {
        SmbFileSystem fileSystem = new SmbFileSystem();
        fileSystem.setUri(appConfig.getShareUrl());
        InputStream in = fileSystem.open(criteria.getFileName());
        IOUtils.flow(in, response.getOutputStream(), true, true);
    }

    @ApiOperation("工单查询")
    @PostMapping("/mocta/getMoctaList")
    List<MoctaDto> getMoctaList(@RequestBody MoctaCriteria criteria){
        return moctaService.getMoctaList(criteria);
    }
    @ApiOperation("工单材料查询")
    @PostMapping("/moctb/getMoctbList")
    List<MoctbDto> getMoctaList(@RequestBody MoctbCriteria criteria){
        return moctaService.getMoctbList(criteria);
    }

    @ApiOperation("工单MES更新标识")
    @PostMapping("/mocta/syncMark")
    void updateSyncMark(@RequestBody MoctaUpdateParams params){
        moctaService.updateSyncMark(params);
    }

    @ApiOperation("工单状态更新")
    @PostMapping("/mocta/updateState")
    void updateState(@RequestBody MoctaUpdateParams params){
        moctaService.updateState(params);
    }


}
