package com.topsunit.scanservice.ximai.controller;

import cn.hutool.core.bean.BeanUtil;
import com.topsunit.scanservice.ximai.dao.ExAccountInfoDao;
import com.topsunit.scanservice.ximai.dto.CopmaCriteria;
import com.topsunit.scanservice.ximai.dto.CopmaDto;
import com.topsunit.scanservice.ximai.dto.ExAccountInfoDto;
import com.topsunit.scanservice.ximai.entity.Copma;
import com.topsunit.scanservice.ximai.entity.ExAccountInfo;
import com.topsunit.scanservice.ximai.security.PassToken;
import com.topsunit.scanservice.ximai.service.CopmaService;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Title: CommonController</p>
 * <p>Description: 公用Controller</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/17
 */
@RestController
public class CommonController {

    @Autowired
    private ExAccountInfoDao exAccountInfoDao;

    @PassToken
    @ApiOperation("系统套账查询")
    @PostMapping("/common/getExAccountInfo")
    public List<ExAccountInfoDto> getExAccountInfo(){
        Specification<ExAccountInfo> query = new Specification<ExAccountInfo>() {
            @Override
            public Predicate toPredicate(Root<ExAccountInfo> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicates = new ArrayList<Predicate>();
                Predicate predicate = criteriaBuilder.equal(root.get("enable"), 1);
                predicates.add(predicate);
                criteriaQuery.orderBy(criteriaBuilder.asc(root.get("serial")));
                return criteriaQuery.where(predicates.toArray(new Predicate[0])).getRestriction();
            }
        };
        return exAccountInfoDao.findAll(query).stream().map(s-> BeanUtil.copyProperties(s, ExAccountInfoDto.class))
                .collect(Collectors.toList());
    }

}
