package com.topsunit.scanservice.ximai.app;

import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.common.Version;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import springfox.documentation.oas.annotations.EnableOpenApi;

/**
 * <p>Title: Application</p>
 * <p>Description: Application</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/18
 */
@SpringBootApplication
@ComponentScan(basePackages = {"com.topsunit"})
@EntityScan("com.topsunit")
@EnableJpaRepositories("com.topsunit")
@EnableFeignClients(basePackages = {"com.topsunit"})
@EnableKnife4j
@EnableOpenApi
public class Application {
    public static void main(String[] args) {
        Version.INSTANCE.setVersion("4.0.0.1");
        if(args!=null && args.length>0){
            Version.INSTANCE.setArgs(args[0]);
        }
        SpringApplication application = new SpringApplication(Application.class);
        application.run(args);
    }


}
