package com.topsunit.scanservice.ximai.controller;

import com.topsunit.scanservice.ximai.dto.CopmaCriteria;
import com.topsunit.scanservice.ximai.dto.CopmaDto;
import com.topsunit.scanservice.ximai.dto.PurmaCriteria;
import com.topsunit.scanservice.ximai.dto.PurmaDto;
import com.topsunit.scanservice.ximai.service.CopmaService;
import com.topsunit.scanservice.ximai.service.PurmaService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>Title: CopmaController</p>
 * <p>Description: 客户</p>
 *
 * @author chicheng.li
 * @version V1.0
 * @date 2024/10/17
 */
@RestController
public class CopmaController {

    @Autowired
    private CopmaService copmaService;

    @ApiOperation("查询客户列表")
    @PostMapping("/copma/getCopmaList")
    public List<CopmaDto> getCopmaList(@RequestBody CopmaCriteria criteria){
        return copmaService.getCopmaDtoList(criteria);
    }

}
