package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: SfctcId</p>
 * <p>Description: 转移单单身档Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/28
 */
public class SfctcId implements Serializable {
    public SfctcId() {
    }

    public SfctcId(String tc001, String tc002, String tc003) {
        this.tc001 = String.format("%1$-4s", tc001);
        this.tc002 = String.format("%1$-11s", tc002);
        this.tc003 = String.format("%1$-4s", tc003);
    }

    private String tc001;
    private String tc002;
    private String tc003;

    public String getTc001() {
        return tc001;
    }

    public void setTc001(String tc001) {
        this.tc001 = tc001;
    }

    public String getTc002() {
        return tc002;
    }

    public void setTc002(String tc002) {
        this.tc002 = tc002;
    }

    public String getTc003() {
        return tc003;
    }

    public void setTc003(String tc003) {
        this.tc003 = tc003;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SfctcId sfctcId = (SfctcId) o;
        return tc001.equals(sfctcId.tc001) && tc002.equals(sfctcId.tc002) && tc003.equals(sfctcId.tc003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tc001, tc002, tc003);
    }
}
