package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * <p>Title: CmsmgId</p>
 * <p>Description: 币种汇率档单身Id</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/10/26
 */
public class CmsmgId implements Serializable {
    public CmsmgId() {
    }

    public CmsmgId(String mg001, String mg002) {
        this.mg001 = String.format("%1$-4s",mg001);
        this.mg002 = String.format("%1$-8s",mg002);
    }

    private String mg001;
    private String mg002;

    public String getMg001() {
        return mg001;
    }

    public void setMg001(String mg001) {
        this.mg001 = mg001;
    }

    public String getMg002() {
        return mg002;
    }

    public void setMg002(String mg002) {
        this.mg002 = mg002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CmsmgId cmsmgId = (CmsmgId) o;
        return mg001.equals(cmsmgId.mg001) && mg002.equals(cmsmgId.mg002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(mg001, mg002);
    }
}
